@echo off
setlocal enabledelayedexpansion

:: Change directory to the directory of the script
cd /d "%~dp0"

:: Set the directories
set PROCESS_DIR=ylm2-to-process
set COMPLETED_DIR=ylm2-completed
set FAILED_DIR=ylm2-failed

:: Expand COMPLETED_DIR to a full path and store it in COMPLETED_DIR_EXPANDED
for %%i in ("%COMPLETED_DIR%") do set COMPLETED_DIR_EXPANDED=%%~fi

echo Starting the ylm2 file processing script...
echo.

:: Create directories if they don't exist
echo Checking if necessary directories exist...
if not exist "%PROCESS_DIR%" (
    echo Creating directory: %PROCESS_DIR%
    mkdir "%PROCESS_DIR%"
)
if not exist "%COMPLETED_DIR%" (
    echo Creating directory: %COMPLETED_DIR%
    mkdir "%COMPLETED_DIR%"
)
if not exist "%FAILED_DIR%" (
    echo Creating directory: %FAILED_DIR%
    mkdir "%FAILED_DIR%"
)
echo Directory setup complete.
echo.

:processLoop
echo ylm2: Waiting for files in "%PROCESS_DIR%" folder to be processed...
:: Check for files in the processing directory
for %%F in ("%PROCESS_DIR%\*.*") do (
    echo.
    echo Found file: %%~nxF
    echo Processing file: %%~nxF...
    call ylm2 --export-type "TEXT_SUMMARY" --export-folder-path "%COMPLETED_DIR_EXPANDED%" --input-file-path "%%~fF"
    if errorlevel 1 (
        echo ERROR: Failed to process file: %%~nxF
        move "%%F" "%FAILED_DIR%\%%~nxF"
		echo.
        echo File moved to: %FAILED_DIR%
    ) else (
        echo SUCCESS: File processed successfully: %%~nxF
        move "%%F" "%COMPLETED_DIR%\%%~nxF"
		echo.
        echo File moved to: %COMPLETED_DIR%
    )
    echo.
)

:: Wait for 3 seconds before checking again
timeout /t 3 /nobreak >nul

:: Loop back to processing
goto processLoop